<?php

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

$url = $_GET["path"];
$parts = explode('/', $url);

$username = $parts[0];
$password = $parts[1];
$stream = $parts[2];

// Lê o arquivo JSON de DNSs
$dnsFile = './dns_file.json';
if (file_exists($dnsFile)) {
    $arr = json_decode(file_get_contents($dnsFile), true);
} else {
    $arr = [];
}

$dns = NULL;

// Tenta autenticar com os DNSs encontrados no arquivo JSON
foreach ($arr as $dns3) {
    if (is_string($dns3)) {
        $api_call = call_api($dns3 . "/player_api.php?username=" . $username . "&password=" . $password);
        
        if ($api_call && $api_call->user_info->auth == 1 && $api_call->user_info->status == "Active") {
            $dns = $dns3;
            break; 
        }
    }
}

// Se um DNS válido foi encontrado, redireciona para o stream
if ($dns !== NULL) {
    $url = $dns . '/live/' . $url;
    // Envia o cabeçalho de "fechar a conexão" após o redirecionamento
    header("Connection: close");
    header("Location: " . $url);
    flush(); // Garante que o cabeçalho seja enviado
    die();
}

// Função para chamar a API e obter a resposta
function call_api($api_link)
{
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $api_link);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);  // Ajusta o timeout
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    $result = json_decode(curl_exec($ch));
    curl_close($ch);

    if (!empty($result)) {
        return $result;
    }
    return NULL;  // Retorna NULL caso não receba resposta válida
}
?>
