<?php
ini_set('display_errors', 0);

// Conecta ao banco de dados SQLite
$db = new SQLite3('.db.db');

// Coleta as URLs dos servidores DNS do banco de dados
$dnsList = [];
$res = $db->query("SELECT * FROM dns");
while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
    $dnsList[] = $row['url'];
}

// Extrai os parâmetros da URL (tipo, username, password, id)
$requestPath = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$parts = explode('/', $requestPath);
$lastParts = array_slice($parts, -4); // Pode ser tipo, user, pass, id

if (count($lastParts) < 3) {
    die("Credenciais ou tipo de conteúdo ausentes.");
}

$contentType = $lastParts[0]; // 'live', 'movie' ou 'series'
$username = $lastParts[1];
$password = $lastParts[2];
$contentId = $lastParts[3] ?? '';

// Função para validar via player_api
function isValid($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, "Mozilla/5.0");

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    return ($http_code == 200 && strpos($response, '"auth":1') !== false) ? json_decode($response, true) : false;
}

// Loop para validar usuário e redirecionar
foreach ($dnsList as $dns) {
    $dns = rtrim($dns, '/');
    $url = "$dns/player_api.php?username=" . urlencode($username) . "&password=" . urlencode($password);

    $response = isValid($url);

    if ($response && isset($response['user_info']) && $response['user_info']['auth'] == 1) {
        $serverUrl = $response['server_info']['url'] ?? '';
        $serverPort = $response['server_info']['port'] ?? '80';
        $serverProtocol = $response['server_info']['server_protocol'] ?? 'http';

        // Monta URL final dependendo do tipo
        if ($contentType === 'movie' || $contentType === 'series') {
            $redirectUrl = "$serverProtocol://$serverUrl:$serverPort/$contentType/$username/$password/$contentId";
        } else {
            // live ou outro tipo
            $redirectUrl = "$serverProtocol://$serverUrl:$serverPort/$username/$password/$contentId";
        }

        // Redireciona com 302
        header("Location: $redirectUrl", true, 302);
        exit;
    }
}

// Falha
http_response_code(401);
echo "Falha na autenticação.";
