<?php

ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(E_ALL);

// Função para obter as URLs DNS do banco de dados
function getDnsUrls($dbPath) {
    $db = new SQLite3($dbPath);
    $res = $db->query("SELECT url FROM dns");
    $urls = [];

    while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
        $urls[] = $row['url'];
    }

    return $urls;
}

// Função para chamar a API e verificar se o usuário está autenticado
function callApi($url, $username, $password) {
    $apiLink = $url . "/player_api.php?username=" . $username . "&password=" . $password;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiLink);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    $result = json_decode(curl_exec($ch), true);
    curl_close($ch);

    return $result;
}

// Função para redirecionar para a URL desejada
function redirectToUrl($url) {
    header("Location: " . $url);
    die();
}

// Função principal para processar a requisição
function processRequest($dbPath, $urlPath) {
    // Extrair os parâmetros da URL
    $parts = explode('/', $urlPath);
    $username = $parts[0] ?? '';
    $password = $parts[1] ?? '';
    $stream = $parts[2] ?? '';

    if (!$username || !$password || !$stream) {
        // Se faltar algum parâmetro, redireciona para o Google
        redirectToUrl('https://google.com');
    }

    // Obter os DNSs do banco de dados
    $dnsUrls = getDnsUrls($dbPath);
    $validDns = null;

    // Verificar se o usuário está ativo em algum dos DNSs
    foreach ($dnsUrls as $dns) {
        $apiResult = callApi($dns, $username, $password);

        if (isset($apiResult['user_info']) && $apiResult['user_info']['auth'] == 1 && $apiResult['user_info']['status'] == 'Active') {
            $validDns = $dns;
            break;
        }
    }

    // Se encontrar um DNS válido, redireciona para o stream
    if ($validDns !== null) {
        $redirectUrl = $validDns . '/timeshift/' . $username . '/' . $password . '/' . $stream;
        redirectToUrl($redirectUrl);
    } else {
        // Caso contrário, redireciona para o Google
        redirectToUrl('https://google.com');
    }
}

// Processar a requisição com os parâmetros adequados
processRequest('./.boxbrdb.db', $_GET["path"]);

?>
