<?php
session_start();

// Defina o diretório onde os APKs serão salvos (certifique-se de que esta pasta exista e tenha permissões de escrita)
$uploadDir = __DIR__ . '/ota/';

// Defina o caminho para o arquivo versao_app.json DENTRO da pasta ota
$versaoAppJsonPath = __DIR__ . '/ota/versao_app.json';

// Função para gerar um nome de arquivo seguro
function sanitizeFilename($filename) {
    $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $filename);
    return $filename;
}

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['versao']) && isset($_FILES['apk_file'])) {
        $versao = trim($_POST['versao']);
        $apkFile = $_FILES['apk_file'];

        // Validações básicas
        if (empty($versao)) {
            echo json_encode(['status' => 'erro', 'mensagem' => 'A versão não pode estar vazia.']);
            exit;
        }

        if ($apkFile['error'] !== UPLOAD_ERR_OK) {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Erro ao fazer o upload do arquivo APK. Código: ' . $apkFile['error']]);
            exit;
        }

        if ($apkFile['type'] !== 'application/vnd.android.package-archive') {
            echo json_encode(['status' => 'erro', 'mensagem' => 'O arquivo enviado não é um APK.']);
            exit;
        }

        if ($apkFile['size'] > 50 * 1024 * 1024) { // Limite de 50MB (ajuste conforme necessário)
            echo json_encode(['status' => 'erro', 'mensagem' => 'O arquivo APK é muito grande.']);
            exit;
        }

        // Gera um nome de arquivo seguro com a versão
        $nomeBase = pathinfo($apkFile['name'], PATHINFO_FILENAME);
        $nomeSeguro = sanitizeFilename($nomeBase) . '_' . sanitizeFilename($versao) . '.apk';
        $caminhoCompleto = $uploadDir . $nomeSeguro;

        // Move o arquivo para o diretório de upload
        if (move_uploaded_file($apkFile['tmp_name'], $caminhoCompleto)) {
            // Atualiza o arquivo versao_app.json
            $data = [
                'versao_recente' => $versao,
                'url_apk' => 'https://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/' . basename($uploadDir) . '/' . $nomeSeguro
            ];

            if (file_put_contents($versaoAppJsonPath, json_encode($data, JSON_PRETTY_PRINT))) {
                echo json_encode(['status' => 'sucesso', 'mensagem' => 'Nova versão do aplicativo enviada e informações atualizadas.']);
            } else {
                echo json_encode(['status' => 'erro', 'mensagem' => 'Erro ao atualizar o arquivo de versão.']);
                // Opcional: Apagar o APK enviado em caso de falha ao atualizar o JSON
                unlink($caminhoCompleto);
            }
        } else {
            echo json_encode(['status' => 'erro', 'mensagem' => 'Erro ao salvar o arquivo APK no servidor.']);
        }

    } else {
        echo json_encode(['status' => 'erro', 'mensagem' => 'Dados de versão ou arquivo APK não recebidos.']);
    }
} else {
    echo json_encode(['status' => 'erro', 'mensagem' => 'Método de requisição inválido. Use POST.']);
}
?>