<?php
// URL do JSON
$json_url = "http://launcher.dgsp.xyz/at/img/api.json";

// Pega e decodifica o JSON
$response = file_get_contents($json_url);
$data = json_decode($response, true);

// Caminho base das imagens
$base_url = "http://launcher.dgsp.xyz/at/img/";

// Pegando os banners
$banners = [];
if ($data && $data['msg'] === 'success') {
    $item = $data['data'][0];
    $banners[] = $base_url . $item['cads'];
    $banners[] = $base_url . $item['cads2'];
    $banners[] = $base_url . $item['cads3'];
     $banners[] = $base_url . $item['cads4'];
     $banners[] = $base_url . $item['cads5'];
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Slideshow de Imagens</title>
    <style>
        html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            background: transparent; /* Fundo transparente em vez de preto */
        }

        .slideshow {
            width: 100vw;
            height: 100vh;
            position: relative;
            overflow: hidden;
            border-radius: 30px;
            background: transparent; /* Fundo transparente */
        }

        .slideshow img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            position: absolute;
            top: 0;
            left: 0;
            opacity: 0;
            transition: opacity 1s ease-in-out;
            border-radius: 30px; /* Bordas arredondadas */
            background: transparent; /* Fundo transparente até as imagens carregarem */
        }

        .slideshow img.active {
            opacity: 1;
        }
    </style>
</head>
<body>

<div class="slideshow">
    <?php foreach ($banners as $index => $img): ?>
        <img src="<?= $img ?>" class="<?= $index === 0 ? 'active' : '' ?>">
    <?php endforeach; ?>
</div>

<script>
    const slides = document.querySelectorAll('.slideshow img');
    let current = 0;

    setInterval(() => {
        slides[current].classList.remove('active');
        current = (current + 1) % slides.length;
        slides[current].classList.add('active');
    }, 5000);
</script>

</body>
</html>