<?php
$arquivo = 'jogos_url.txt';

if (!file_exists($arquivo)) {
    http_response_code(404);
    echo "Nenhuma URL configurada.";
    exit;
}

$url = trim(file_get_contents($arquivo));

if (!filter_var($url, FILTER_VALIDATE_URL)) {
    http_response_code(400);
    echo "URL inválida.";
    exit;
}

// Transmite o conteúdo da URL externa
$conteudo = @file_get_contents($url);

if ($conteudo === false) {
    http_response_code(500);
    echo "Erro ao carregar conteúdo.";
    exit;
}

header('Content-Type: text/html; charset=utf-8');
echo $conteudo;
