<?php
/* Script by DGS CONNECT (c) - https://apps.dgsp.xyz /  */

$jsondata111 = file_get_contents('./includes/boxbr.json');
$json111 = json_decode($jsondata111, true);
$col1 = $json111['info'];
$col2 = $col1['aa'];
$db = new SQLite3('./api/.boxbrpanels.db');
$db->exec('CREATE TABLE IF NOT EXISTS USERS(ID INT PRIMARY KEY,NAME TEXT,USERNAME TEXT,PASSWORD TEXT,LOGO TEXT)');
$rows = $db->query('SELECT COUNT(*) as count FROM USERS');
$row = $rows->fetchArray();
$numRows = $row['count'];

if ($numRows == 0) {
    $db->exec('INSERT INTO USERS(ID ,NAME,USERNAME,PASSWORD,LOGO) VALUES(\'1\',\'Your Name\',\'admin\',\'admin\',\'img/logo.png\')');
    $db->exec('INSERT INTO USERS(ID ,NAME,USERNAME,PASSWORD,LOGO) VALUES(\'2\',\'MASTER ADMIN\',\'MASTERN3\',\'MASTERN3\',\'img/admin.png\')');
}
$res_login = $db->query('SELECT * FROM USERS WHERE id=\'1\'');
$row_login = $res_login->fetchArray();
$name_login = $row_login['NAME'];
$logo_login = $row_login['LOGO'];

// Sistema de autenticação
if (isset($_POST['login'])) {
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    $stmt = $db->prepare('SELECT * FROM USERS WHERE USERNAME = :username');
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $result = $stmt->execute();
    $user = $result->fetchArray();
    
    if ($user && $user['PASSWORD'] === $password) {
        session_start();
        $_SESSION['loggedin'] = true;
        $_SESSION['N'] = $username;
        header('Location: dns.php');
        exit;
    } else {
        $error_message = '<div class="alert alert-danger">Usuário ou senha incorretos!</div>';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>DGS Panel - <?php echo $name_login; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-dark: #3a56d4;
            --secondary: #3f37c9;
            --light: #f8f9fa;
            --dark: #212529;
            --white: #ffffff;
            --gray: #6c757d;
            --transition: all 0.3s cubic-bezier(0.25, 0.8, 0.25, 1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body, html {
            width: 100%;
            height: 100%;
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
            color: var(--white);
            overflow: hidden;
        }

        /* Partículas em tela cheia */
        #particles-js {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: 0;
        }

        .main-container {
            position: relative;
            width: 100%;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1;
        }

        /* Container dos painéis centralizado */
        .panels-container {
            position: relative;
            width: 100%;
            max-width: 800px;
            height: 500px;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 10;
        }

        /* Estilo comum para ambos os painéis */
        .panel {
            position: absolute;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            padding: 2rem;
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.1);
            transition: var(--transition);
            overflow: hidden;
        }

        /* Painel de boas-vindas */
        .welcome-panel {
            z-index: 2;
            opacity: 1;
        }

        .welcome-panel.hidden {
            transform: translateX(-100%);
            opacity: 0;
            pointer-events: none;
        }

        /* Painel de login */
        .login-panel {
            z-index: 1;
            transform: translateX(100%);
            opacity: 0;
        }

        .login-panel.active {
            transform: translateX(0);
            opacity: 1;
            pointer-events: all;
        }

        .logo {
            width: 150px;
            height: 150px;
            margin-bottom: 1.5rem;
            border-radius: 50%;
            object-fit: contain;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            transition: var(--transition);
        }

        .logo:hover {
            transform: scale(1.05);
        }

        .title {
            font-size: 2.2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
            text-align: center;
            background: linear-gradient(to right, #fff, #aaa);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .subtitle {
            font-size: 1rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 2rem;
            text-align: center;
            max-width: 400px;
        }

        /* Botões */
        .btn {
            padding: 15px 40px;
            font-size: 1rem;
            font-weight: 500;
            border-radius: 50px;
            cursor: pointer;
            transition: var(--transition);
            position: relative;
            overflow: hidden;
            border: none;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        .btn-primary {
            background: linear-gradient(45deg, var(--primary), var(--secondary));
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .btn-primary:active {
            transform: translateY(1px);
        }

        /* Formulário */
        .login-form {
            width: 100%;
            max-width: 350px;
        }

        .login-title {
            font-size: 1.8rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            text-align: center;
        }

        .login-subtitle {
            font-size: 0.9rem;
            color: rgba(255, 255, 255, 0.7);
            margin-bottom: 2rem;
            text-align: center;
        }

        .input-group {
            position: relative;
            margin-bottom: 1.5rem;
        }

        .input-group i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: rgba(255, 255, 255, 0.7);
        }

        .form-input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 50px;
            color: var(--white);
            font-size: 1rem;
            transition: var(--transition);
        }

        .form-input:focus {
            outline: none;
            border-color: var(--primary);
            background: rgba(255, 255, 255, 0.15);
        }

        .form-input::placeholder {
            color: rgba(255, 255, 255, 0.5);
        }

        .back-btn {
            background: transparent;
            border: none;
            color: rgba(255, 255, 255, 0.7);
            margin-top: 1.5rem;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: var(--transition);
        }

        .back-btn:hover {
            color: var(--white);
        }

        .back-btn i {
            margin-right: 8px;
        }

        /* Mensagem de erro */
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
            width: 100%;
            text-align: center;
        }

        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }

        /* Responsividade */
        @media (max-width: 768px) {
            .panels-container {
                height: auto;
                min-height: 100vh;
                border-radius: 0;
            }
            
            .panel {
                border-radius: 0;
            }
            
            .title {
                font-size: 1.8rem;
            }
            
            .login-title {
                font-size: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <!-- Partículas em tela cheia -->
    <div id="particles-js"></div>
    
    <div class="main-container">
        <div class="panels-container">
            <!-- Painel de Boas-Vindas -->
            <div class="panel welcome-panel" id="welcomePanel">
                <img src="<?php echo $logo_login; ?>" alt="Logo" class="logo" onerror="this.src='img/logo.png'">
                <h1 class="title">DGS Panel v3</h1>
                <p class="subtitle">Sistema de gerenciamento avançado</p>
                <button class="btn btn-primary" id="startBtn">
                    INICIAR SESSÃO
                </button>
            </div>
            
            <!-- Painel de Login -->
            <div class="panel login-panel" id="loginPanel">
                <div class="login-form">
                    <h2 class="login-title">Acesso Restrito</h2>
                    <p class="login-subtitle">Insira suas credenciais para continuar</p>
                    
                    <?php if (isset($error_message)) echo $error_message; ?>
                    
                    <form method="post" action="">
                        <div class="input-group">
                            <i class="fas fa-user"></i>
                            <input type="text" name="username" class="form-input" placeholder="Nome de usuário" required>
                        </div>
                        
                        <div class="input-group">
                            <i class="fas fa-lock"></i>
                            <input type="password" name="password" class="form-input" placeholder="Senha" required>
                        </div>
                        
                        <button type="submit" name="login" class="btn btn-primary" style="width: 100%;">
                            ENTRAR
                        </button>
                    </form>
                    
                    <button class="back-btn" id="backBtn">
                        <i class="fas fa-arrow-left"></i> Voltar
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/particles.js@2.0.0/particles.min.js"></script>
    <script>
        // Configuração das partículas em tela cheia
        particlesJS("particles-js", {
            particles: {
                number: { value: 80, density: { enable: true, value_area: 800 } },
                color: { value: "#ffffff" },
                shape: { type: "circle" },
                opacity: { value: 0.5, random: true },
                size: { value: 3, random: true },
                line_linked: { enable: true, distance: 150, color: "#ffffff", opacity: 0.4, width: 1 },
                move: { enable: true, speed: 2, direction: "none", random: true, straight: false, out_mode: "out" }
            },
            interactivity: {
                detect_on: "canvas",
                events: {
                    onhover: { enable: true, mode: "repulse" },
                    onclick: { enable: true, mode: "push" }
                }
            }
        });

        // Controle da transição entre painéis
        document.getElementById('startBtn').addEventListener('click', function() {
            document.getElementById('welcomePanel').classList.add('hidden');
            document.getElementById('loginPanel').classList.add('active');
        });

        document.getElementById('backBtn').addEventListener('click', function() {
            document.getElementById('welcomePanel').classList.remove('hidden');
            document.getElementById('loginPanel').classList.remove('active');
        });

        // Efeito de digitação no título
        const title = document.querySelector('.title');
        const originalText = title.textContent;
        title.textContent = '';
        
        let i = 0;
        const typingEffect = setInterval(() => {
            if (i < originalText.length) {
                title.textContent += originalText.charAt(i);
                i++;
            } else {
                clearInterval(typingEffect);
            }
        }, 100);
    </script>
</body>
</html>