<?php
// Incluindo cabeçalho (header)
include 'includes/header.php';

// Conectar ao banco de dados de usuários
$user_db = new SQLite3('./api/boxbrdb.db');

// Verificar se a tabela de usuários existe, se não, criar
$user_db->exec("CREATE TABLE IF NOT EXISTS usuarios (
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    username TEXT NOT NULL,
    password TEXT NOT NULL,
    dns TEXT NOT NULL,
    validade TEXT NOT NULL,
    device_id TEXT
)");

// Ação de buscar
$searchQuery = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['search'])) {
    $searchQuery = trim($_POST['search']);
    $stmt = $user_db->prepare("SELECT * FROM usuarios WHERE username LIKE :search OR password LIKE :search OR dns LIKE :search OR device_id LIKE :search");
    $searchParam = "%$searchQuery%";
    $stmt->bindValue(':search', $searchParam, SQLITE3_TEXT);
    $users = $stmt->execute();
} else {
    $users = $user_db->query("SELECT * FROM usuarios ORDER BY id DESC");
}

// Processar ações
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        
        // Ações que requerem ID
        if (in_array($action, ['block', 'unblock', 'update_validade', 'delete']) && isset($_POST['id'])) {
            $id = (int)$_POST['id'];
            
            // Ação de bloqueio
            if ($action === 'block') {
                $stmt = $user_db->prepare("UPDATE usuarios SET validade = ? WHERE id = ?");
                $stmt->bindValue(1, date('Y-m-d H:i:s', strtotime('yesterday')), SQLITE3_TEXT);
                $stmt->bindValue(2, $id, SQLITE3_INTEGER);
                $stmt->execute();
                $message = "Usuário bloqueado com sucesso!";
            }
            
            // Ação de desbloqueio
            if ($action === 'unblock') {
                $stmt = $user_db->prepare("UPDATE usuarios SET validade = ? WHERE id = ?");
                $stmt->bindValue(1, date('Y-m-d H:i:s', strtotime('+7 days')), SQLITE3_TEXT);
                $stmt->bindValue(2, $id, SQLITE3_INTEGER);
                $stmt->execute();
                $message = "Usuário desbloqueado com sucesso!";
            }
            
            // Ação de alterar validade
            if ($action === 'update_validade' && isset($_POST['validade'])) {
                $validade = $_POST['validade'];
                if ($validade == 'Ilimitado') {
                    $validade = '2050-01-01';
                } else {
                    $validade = date('Y-m-d H:i:s', strtotime($validade));
                }
                
                $stmt = $user_db->prepare("UPDATE usuarios SET validade = ? WHERE id = ?");
                $stmt->bindValue(1, $validade, SQLITE3_TEXT);
                $stmt->bindValue(2, $id, SQLITE3_INTEGER);
                $stmt->execute();
                $message = "Validade atualizada com sucesso!";
            }
            
            // Ação de deletar usuário
            if ($action === 'delete') {
                $stmt = $user_db->prepare("DELETE FROM usuarios WHERE id = ?");
                $stmt->bindValue(1, $id, SQLITE3_INTEGER);
                $stmt->execute();
                $message = "Usuário deletado com sucesso!";
            }
        }
        
        // Ação de atualizar validade para todos os usuários
        if ($action === 'update_all' && isset($_POST['validade'])) {
            $validade = $_POST['validade'];
            if ($validade == 'Ilimitado') {
                $validade = '2050-01-01';
            } else {
                $validade = date('Y-m-d H:i:s', strtotime($validade));
            }
            
            $stmt = $user_db->prepare("UPDATE usuarios SET validade = ?");
            $stmt->bindValue(1, $validade, SQLITE3_TEXT);
            $stmt->execute();
            $message = "Todos os usuários foram atualizados!";
        }
        
        // Ação de limpar todos os usuários
        if ($action === 'clear_all') {
            $user_db->exec("DELETE FROM usuarios");
            $user_db->exec("VACUUM");
            $message = "Todos os usuários foram removidos!";
        }
        
        // Ação de migrar DNS
        if ($action === 'migrate_dns' && isset($_POST['dns_antigo']) && isset($_POST['dns_novo'])) {
            $dns_antigo = trim($_POST['dns_antigo']);
            $dns_novo = trim($_POST['dns_novo']);
            
            $stmt = $user_db->prepare("UPDATE usuarios SET dns = ? WHERE dns = ?");
            $stmt->bindValue(1, $dns_novo, SQLITE3_TEXT);
            $stmt->bindValue(2, $dns_antigo, SQLITE3_TEXT);
            $stmt->execute();
            $message = "DNS migrado com sucesso!";
        }
    }
}

// Adicionar novo usuário via GET (para API)
if ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['username']) && isset($_GET['password']) && isset($_GET['dns'])) {
    $username = trim($_GET['username']);
    $password = trim($_GET['password']);
    $dns = trim($_GET['dns']);
    $device_id = isset($_GET['device_id']) ? trim($_GET['device_id']) : 'desconhecido'; // Captura o device_id, se fornecido
    $validade = date('Y-m-d H:i:s', strtotime('+7 days'));
    
    $stmt = $user_db->prepare("INSERT INTO usuarios (username, password, dns, validade, device_id) VALUES (:username, :password, :dns, :validade, :device_id)");
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $stmt->bindValue(':password', $password, SQLITE3_TEXT);
    $stmt->bindValue(':dns', $dns, SQLITE3_TEXT);
    $stmt->bindValue(':validade', $validade, SQLITE3_TEXT);
    $stmt->bindValue(':device_id', $device_id, SQLITE3_TEXT); // Insere o device_id
    $stmt->execute();
    
    // Retorna JSON para API
    if (isset($_GET['api'])) {
        header('Content-Type: application/json');
        echo json_encode(['status' => 'success', 'message' => 'Usuário criado com sucesso']);
        exit;
    }
}
?>


<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciador de Usuários</title>
    <style>
    /* Estilos melhorados e responsivos */
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        margin: 0;
        padding: 0;
        background-color: #f5f5f5;
        color: #333;
    }
    
    .container {
        width: 95%;
        max-width: 1200px;
        margin: 20px auto;
        padding: 20px;
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }
    
    h1 {
        text-align: center;
        color: #2c3e50;
        margin-bottom: 30px;
    }
    
    .alert {
        padding: 15px;
        margin-bottom: 20px;
        border-radius: 4px;
        color: #fff;
    }
    
    .alert-success {
        background-color: #28a745;
    }
    
    .search-container {
        display: flex;
        margin-bottom: 20px;
        gap: 10px;
    }
    
    .search-box {
        flex: 1;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-size: 16px;
    }
    
    .search-button {
        padding: 10px 20px;
        background-color: #3498db;
        color: white;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    
    .search-button:hover {
        background-color: #2980b9;
    }
    
    .action-buttons {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 20px;
    }
    
    .action-form {
        display: flex;
        align-items: center;
        gap: 10px;
        background-color: #f8f9fa;
        padding: 15px;
        border-radius: 4px;
    }
    
    select, input[type="text"] {
        padding: 8px;
        border: 1px solid #ddd;
        border-radius: 4px;
    }
    
    .btn {
        padding: 8px 15px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        transition: background-color 0.3s;
    }
    
    .btn-primary {
        background-color: #3498db;
        color: white;
    }
    
    .btn-success {
        background-color: #28a745;
        color: white;
    }
    
    .btn-danger {
        background-color: #dc3545;
        color: white;
    }
    
    .btn-warning {
        background-color: #ffc107;
        color: #212529;
    }
    
    .btn:hover {
        opacity: 0.9;
    }
    
    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 20px;
    }
    
    th, td {
        padding: 12px 15px;
        text-align: left;
        border-bottom: 1px solid #ddd;
    }
    
    th {
        background-color: #3498db;
        color: white;
    }
    
    tr:nth-child(even) {
        background-color: #f2f2f2;
    }
    
    tr:hover {
        background-color: #e9e9e9;
    }
    
    .status-active {
        color: #28a745;
        font-weight: bold;
    }
    
    .status-expired {
        color: #dc3545;
        font-weight: bold;
    }
    
    .action-cell {
        display: flex;
        flex-wrap: wrap;
        gap: 5px;
    }
    
    @media (max-width: 768px) {
        .search-container, .action-buttons, .action-form {
            flex-direction: column;
        }
        
        th, td {
            padding: 8px;
            font-size: 14px;
        }
        
        .action-cell {
            flex-direction: column;
        }
    }
    </style>
</head>
<body>
    <div class="container">
        <h1>Gerenciador de Usuários</h1>
        
        <?php if (!empty($message)): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($message); ?></div>
        <?php endif; ?>
        
        <div class="search-container">
            <form method="POST" action="">
                <input type="text" name="search" class="search-box" placeholder="Buscar por usuário, senha, DNS ou device ID..." value="<?php echo htmlspecialchars($searchQuery); ?>">
                <button type="submit" class="search-button">Buscar</button>
            </form>
        </div>
        
        <div class="action-buttons">
            <form method="POST" class="action-form">
                <input type="hidden" name="action" value="update_all">
                <label for="validade">Atualizar todos:</label>
                <select name="validade" id="validade" required>
                    <option value="+7 days">7 Dias</option>
                    <option value="+30 days">30 Dias</option>
                    <option value="+180 days">180 Dias</option>
                    <option value="+360 days">360 Dias</option>
                    <option value="Ilimitado">Ilimitado</option>
                </select>
                <button type="submit" class="btn btn-primary">Aplicar</button>
            </form>
            
            <form method="POST" class="action-form" onsubmit="return confirm('Tem certeza que deseja remover TODOS os usuários?');">
                <input type="hidden" name="action" value="clear_all">
                <button type="submit" class="btn btn-danger">Limpar Todos</button>
            </form>
            
            <form method="POST" class="action-form">
                <input type="hidden" name="action" value="migrate_dns">
                <label for="dns_antigo">Migrar DNS:</label>
                <input type="text" name="dns_antigo" id="dns_antigo" placeholder="DNS Antigo" required>
                <input type="text" name="dns_novo" id="dns_novo" placeholder="DNS Novo" required>
                <button type="submit" class="btn btn-warning">Migrar</button>
            </form>
        </div>
        
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Usuário</th>
                    <th>Senha</th>
                    <th>DNS</th>
                    <th>Validade</th>
                    <th>Device ID</th>
                    <th>Status</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($user = $users->fetchArray(SQLITE3_ASSOC)): ?>
                    <?php 
                    $isActive = ($user['validade'] == '2050-01-01' || strtotime($user['validade']) > time());
                    $statusClass = $isActive ? 'status-active' : 'status-expired';
                    $statusText = $isActive ? 'Ativo' : 'Expirado';
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($user['id']); ?></td>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo htmlspecialchars($user['password']); ?></td>
                        <td><?php echo htmlspecialchars($user['dns']); ?></td>
                        <td><?php echo htmlspecialchars($user['validade']); ?></td>
                        <td><?php echo htmlspecialchars($user['device_id'] ?? 'N/A'); ?></td>
                        <td class="<?php echo $statusClass; ?>"><?php echo $statusText; ?></td>
                        <td class="action-cell">
                            <?php if ($isActive): ?>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="block">
                                    <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                    <button type="submit" class="btn btn-danger">Bloquear</button>
                                </form>
                            <?php else: ?>
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="action" value="unblock">
                                    <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                    <button type="submit" class="btn btn-success">Desbloquear</button>
                                </form>
                            <?php endif; ?>
                            
                            <form method="POST" style="display: inline;">
                                <input type="hidden" name="action" value="update_validade">
                                <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                <select name="validade" required style="padding: 5px;">
                                    <option value="+7 days">7 Dias</option>
                                    <option value="+30 days">30 Dias</option>
                                    <option value="+180 days">180 Dias</option>
                                    <option value="+360 days">360 Dias</option>
                                    <option value="Ilimitado" <?php echo ($user['validade'] == '2050-01-01') ? 'selected' : ''; ?>>Ilimitado</option>
                                </select>
                                <button type="submit" class="btn btn-primary">Atualizar</button>
                            </form>
                            
                            <form method="POST" style="display: inline;" onsubmit="return confirm('Tem certeza que deseja deletar este usuário?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?php echo $user['id']; ?>">
                                <button type="submit" class="btn btn-danger">Deletar</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>

    <script>
    // Adicionar confirmação para ações importantes
    document.querySelectorAll('form').forEach(form => {
        if (form.querySelector('input[name="action"]')?.value === 'clear_all' || 
            form.querySelector('input[name="action"]')?.value === 'delete') {
            form.addEventListener('submit', (e) => {
                if (!confirm('Esta ação é irreversível. Continuar?')) {
                    e.preventDefault();
                }
            });
        }
    });
    </script>
</body>
</html>

<?php include 'includes/footer.php'; ?>